/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.gradle.AbstractBndrun;
import aQute.bnd.gradle.BndUtils;
import aQute.lib.io.IO;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.osgi.service.resolver.ResolutionException;

@CacheableTask
public class Resolve
extends AbstractBndrun {
    private boolean failOnChanges = false;
    private final RegularFileProperty outputBndrun;
    private boolean reportOptional = true;
    private boolean writeOnChanges = true;

    @Input
    public boolean isFailOnChanges() {
        return this.failOnChanges;
    }

    @Internal
    public boolean getFailOnChanges() {
        return this.isFailOnChanges();
    }

    public void setFailOnChanges(boolean failOnChanges) {
        this.failOnChanges = failOnChanges;
    }

    @OutputFile
    public RegularFileProperty getOutputBndrun() {
        return this.outputBndrun;
    }

    @Input
    public boolean isReportOptional() {
        return this.reportOptional;
    }

    @Internal
    public boolean getReportOptional() {
        return this.isReportOptional();
    }

    public void setReportOptional(boolean reportOptional) {
        this.reportOptional = reportOptional;
    }

    @Input
    public boolean isWriteOnChanges() {
        return this.writeOnChanges;
    }

    @Internal
    public boolean getWriteOnChanges() {
        return this.isWriteOnChanges();
    }

    public void setWriteOnChanges(boolean writeOnChanges) {
        this.writeOnChanges = writeOnChanges;
    }

    public Resolve() {
        this.setGroup("verification");
        org.gradle.api.Project project = this.getProject();
        this.outputBndrun = project.getObjects().fileProperty().convention((Provider)this.getBndrun());
    }

    @Override
    protected Bndrun createBndrun(Workspace workspace, File bndrunFile) throws Exception {
        File outputBndrunFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getOutputBndrun());
        if (!Objects.equals(outputBndrunFile, bndrunFile)) {
            try (PrintWriter writer = IO.writer((File)outputBndrunFile);){
                UTF8Properties props = new UTF8Properties();
                props.setProperty("-include", String.format("\"~%s\"", this.escape(IO.absolutePath((File)bndrunFile))));
                props.store((Writer)writer, null);
            }
            bndrunFile = outputBndrunFile;
        }
        return super.createBndrun(workspace, bndrunFile);
    }

    private String escape(String input) {
        int length = input.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.length() == length ? input : sb.toString();
    }

    @Override
    protected void worker(Project run) throws Exception {
        if (!(run instanceof Bndrun)) {
            throw new GradleException("Resolving a project's bnd.bnd file is not supported by this task. This task can only resolve a bndrun file.");
        }
        Bndrun bndrun = (Bndrun)run;
        this.worker0(bndrun);
    }

    private void worker0(Bndrun run) throws Exception {
        this.getLogger().info("Resolving runbundles required for {}", (Object)run.getPropertiesFile());
        this.getLogger().debug("Run properties: {}", (Object)run.getProperties());
        try {
            String result = run.resolve(this.isFailOnChanges(), this.isWriteOnChanges());
            this.getLogger().info("{}: {}", (Object)"-runbundles", (Object)result);
        }
        catch (ResolutionException e) {
            this.getLogger().error(ResolveProcess.format((ResolutionException)e, (boolean)this.isReportOptional()));
            throw new GradleException(String.format("%s resolution exception", run.getPropertiesFile()), (Throwable)e);
        }
        finally {
            BndUtils.logReport((Report)run, this.getLogger());
        }
        if (!this.isIgnoreFailures() && !run.isOk()) {
            throw new GradleException(String.format("%s resolution failure", run.getPropertiesFile()));
        }
    }
}

