/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Container;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.gradle.BndPluginConvention;
import aQute.bnd.gradle.BndPluginExtension;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.BndWorkspacePlugin;
import aQute.bnd.gradle.Bndrun;
import aQute.bnd.gradle.Export;
import aQute.bnd.gradle.Resolve;
import aQute.bnd.gradle.TestOSGi;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.Processor;
import aQute.bnd.stream.MapStream;
import aQute.bnd.unmodifiable.Maps;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.process.CommandLineArgumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BndPlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger(BndPlugin.class);
    public static final String PLUGINID = "biz.aQute.bnd";
    private Project project;
    private Project workspace;
    private ObjectFactory objects;
    private aQute.bnd.build.Project bndProject;

    public void apply(final Project project) {
        try {
            JavaPluginExtension javaPlugin;
            this.project = project;
            Project workspace = this.workspace = project.getParent();
            ProjectLayout layout = project.getLayout();
            ObjectFactory objects = this.objects = project.getObjects();
            TaskContainer tasks = project.getTasks();
            if (project.getPluginManager().hasPlugin("biz.aQute.bnd.builder")) {
                throw new GradleException("Project already has \"biz.aQute.bnd.builder\" plugin applied.");
            }
            if (Objects.isNull(workspace)) {
                throw new GradleException("The \"biz.aQute.bnd\" plugin cannot be applied to the root project. Perhaps you meant to use the \"biz.aQute.bnd.builder\" plugin?");
            }
            Workspace bndWorkspace = BndWorkspacePlugin.getBndWorkspace(workspace);
            this.bndProject = bndWorkspace.getProject(project.getName());
            final aQute.bnd.build.Project bndProject = this.bndProject;
            if (Objects.isNull(bndProject)) {
                throw new GradleException(String.format("Unable to load bnd project %s from workspace %s", project.getName(), workspace.getLayout().getProjectDirectory()));
            }
            bndProject.prepare();
            if (!bndProject.isValid()) {
                this.checkErrors(project.getLogger());
                throw new GradleException(String.format("Project %s is not a valid bnd project", bndProject.getName()));
            }
            BndPluginExtension extension = (BndPluginExtension)project.getExtensions().create("bnd", BndPluginExtension.class, new Object[]{bndProject});
            project.getConvention().getPlugins().put("bnd", new BndPluginConvention(extension));
            layout.getBuildDirectory().fileValue(bndProject.getTargetDir());
            project.getPluginManager().apply("java");
            if (BndUtils.isGradleCompatible("7.1")) {
                ((BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class)).getLibsDirectory().value((Provider)layout.getBuildDirectory());
                ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getTestResultsDir().value(layout.getBuildDirectory().dir(bndProject.getProperty("test-reports", "test-reports")));
            } else {
                ((BasePluginConvention)project.getConvention().getPlugin(BasePluginConvention.class)).setLibsDirName(".");
                ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).setTestResultsDirName(bndProject.getProperty("test-reports", "test-reports"));
            }
            String bnd_defaultTask = (String)project.findProperty("bnd_defaultTask");
            if (Objects.nonNull(bnd_defaultTask)) {
                project.setDefaultTasks(Strings.split((String)bnd_defaultTask));
            }
            ConfigurationContainer configurations = project.getConfigurations();
            configurations.getByName("runtimeOnly").getArtifacts().clear();
            configurations.getByName("archives").getArtifacts().clear();
            ArtifactHandler artifacts = project.getArtifacts();
            this.decontainer(bndProject.getDeliverables()).forEach(deliverable -> {
                artifacts.add("runtimeOnly", deliverable, cpa -> cpa.builtBy(new Object[]{"jar"}));
                artifacts.add("archives", deliverable, cpa -> cpa.builtBy(new Object[]{"jar"}));
            });
            FileCollection deliverables = configurations.getByName("archives").getArtifacts().getFiles();
            Optional<TaskProvider> generate = bndProject.getGenerate().getInputs().value().filter(files -> !files.isEmpty()).map(files -> tasks.register("generate", t -> {
                t.setDescription("Generate source code");
                t.setGroup("build");
                t.getInputs().files(new Object[]{files}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("generateInputs");
                t.getInputs().files(new Object[]{this.getBuildDependencies("jar")}).withPropertyName("buildDependencies");
                TaskInputFilePropertyBuilder bndConfigurationInput = t.getInputs().files(new Object[]{this.bndConfiguration()}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("bndConfiguration");
                if (BndUtils.isGradleCompatible("7.2")) {
                    bndConfigurationInput.normalizeLineEndings();
                }
                t.getOutputs().dirs(new Object[]{bndProject.getGenerate().getOutputDirs()}).withPropertyName("generateOutputs");
                t.doLast("generate", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        try {
                            bndProject.getGenerate().generate(false);
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Project %s failed to generate", bndProject.getName()), (Throwable)e);
                        }
                        BndPlugin.this.checkErrors(tt.getLogger());
                    }
                });
            }));
            Optional<Action> generateInputAction = generate.map(generateTask -> t -> t.getInputs().files(new Object[]{generateTask}).withPropertyName(generateTask.getName()));
            SourceSetContainer sourceSets = BndUtils.sourceSets(project);
            sourceSets.getByName("main", sourceSet -> {
                ConfigurableFileCollection srcDirs;
                try {
                    srcDirs = objects.fileCollection().from(new Object[]{bndProject.getSourcePath()});
                }
                catch (Exception e) {
                    throw Exceptions.duck((Throwable)e);
                }
                File destinationDir = bndProject.getSrcOutput();
                sourceSet.getJava().setSrcDirs((Iterable)srcDirs);
                sourceSet.getResources().setSrcDirs((Iterable)srcDirs);
                sourceSet.getJava().getDestinationDirectory().fileValue(destinationDir);
                sourceSet.getOutput().setResourcesDir(destinationDir);
                TaskProvider compileTask = tasks.named(sourceSet.getCompileJavaTaskName(), AbstractCompile.class, t -> {
                    t.getDestinationDirectory().fileValue(destinationDir);
                    BndUtils.jarLibraryElements((Task)t, sourceSet.getCompileClasspathConfigurationName());
                });
                generateInputAction.ifPresent(arg_0 -> ((TaskProvider)compileTask).configure(arg_0));
                sourceSet.getOutput().dir(Maps.of((Object)"builtBy", (Object)compileTask.getName()), (Object)destinationDir);
                TaskProvider processResourcesTask = tasks.named(sourceSet.getProcessResourcesTaskName());
                generateInputAction.ifPresent(arg_0 -> ((TaskProvider)processResourcesTask).configure(arg_0));
            });
            sourceSets.getByName("test", sourceSet -> {
                ConfigurableFileCollection srcDirs = objects.fileCollection().from(new Object[]{bndProject.getTestSrc()});
                File destinationDir = bndProject.getTestOutput();
                sourceSet.getJava().setSrcDirs((Iterable)srcDirs);
                sourceSet.getResources().setSrcDirs((Iterable)srcDirs);
                sourceSet.getJava().getDestinationDirectory().fileValue(destinationDir);
                sourceSet.getOutput().setResourcesDir(destinationDir);
                TaskProvider compileTask = tasks.named(sourceSet.getCompileJavaTaskName(), AbstractCompile.class, t -> {
                    t.getDestinationDirectory().fileValue(destinationDir);
                    BndUtils.jarLibraryElements((Task)t, sourceSet.getCompileClasspathConfigurationName());
                });
                sourceSet.getOutput().dir(Maps.of((Object)"builtBy", (Object)compileTask.getName()), (Object)destinationDir);
            });
            project.afterEvaluate(p -> {
                sourceSets.getByName("main", sourceSet -> {
                    LinkedHashMap<String, SourceDirectorySet> sourceDirectorySets = new LinkedHashMap<String, SourceDirectorySet>();
                    ExtensionContainer extensions = sourceSet.getExtensions();
                    extensions.getExtensionsSchema().forEach(schema -> {
                        String name = schema.getName();
                        Object sourceDirectorySet = extensions.getByName(name);
                        if (sourceDirectorySet instanceof SourceDirectorySet) {
                            sourceDirectorySets.put(name, (SourceDirectorySet)sourceDirectorySet);
                        }
                    });
                    new DslObject(sourceSet).getConvention().getPlugins().forEach((name, plugin) -> {
                        Object sourceDirectorySet;
                        if (!sourceDirectorySets.containsKey(name) && (sourceDirectorySet = BndPlugin.getter(plugin, name)) instanceof SourceDirectorySet) {
                            sourceDirectorySets.put((String)name, (SourceDirectorySet)sourceDirectorySet);
                        }
                    });
                    Provider destinationDir = sourceSet.getJava().getClassesDirectory();
                    TaskProvider processResourcesTask = tasks.named(sourceSet.getProcessResourcesTaskName());
                    sourceDirectorySets.forEach((name, sourceDirectorySet) -> {
                        try {
                            TaskProvider compileTask = tasks.named(sourceSet.getCompileTaskName(name), AbstractCompile.class, t -> {
                                t.getDestinationDirectory().value(destinationDir);
                                t.getInputs().files(new Object[]{processResourcesTask}).withPropertyName(processResourcesTask.getName());
                            });
                            generateInputAction.ifPresent(arg_0 -> ((TaskProvider)compileTask).configure(arg_0));
                            sourceDirectorySet.setSrcDirs((Iterable)sourceSet.getJava().getSrcDirs());
                            sourceDirectorySet.getDestinationDirectory().value(destinationDir);
                            sourceSet.getOutput().dir(Maps.of((Object)"builtBy", (Object)compileTask.getName()), (Object)destinationDir);
                        }
                        catch (UnknownDomainObjectException unknownDomainObjectException) {
                            // empty catch block
                        }
                    });
                });
                sourceSets.getByName("test", sourceSet -> {
                    LinkedHashMap<String, SourceDirectorySet> sourceDirectorySets = new LinkedHashMap<String, SourceDirectorySet>();
                    ExtensionContainer extensions = sourceSet.getExtensions();
                    extensions.getExtensionsSchema().forEach(schema -> {
                        String name = schema.getName();
                        Object sourceDirectorySet = extensions.getByName(name);
                        if (sourceDirectorySet instanceof SourceDirectorySet) {
                            sourceDirectorySets.put(name, (SourceDirectorySet)sourceDirectorySet);
                        }
                    });
                    new DslObject(sourceSet).getConvention().getPlugins().forEach((name, plugin) -> {
                        Object sourceDirectorySet;
                        if (!sourceDirectorySets.containsKey(name) && (sourceDirectorySet = BndPlugin.getter(plugin, name)) instanceof SourceDirectorySet) {
                            sourceDirectorySets.put((String)name, (SourceDirectorySet)sourceDirectorySet);
                        }
                    });
                    Provider destinationDir = sourceSet.getJava().getClassesDirectory();
                    TaskProvider processResourcesTask = tasks.named(sourceSet.getProcessResourcesTaskName());
                    sourceDirectorySets.forEach((name, sourceDirectorySet) -> {
                        try {
                            TaskProvider compileTask = tasks.named(sourceSet.getCompileTaskName(name), AbstractCompile.class, t -> {
                                t.getDestinationDirectory().value(destinationDir);
                                t.getInputs().files(new Object[]{processResourcesTask}).withPropertyName(processResourcesTask.getName());
                            });
                            sourceDirectorySet.setSrcDirs((Iterable)sourceSet.getJava().getSrcDirs());
                            sourceDirectorySet.getDestinationDirectory().value(destinationDir);
                            sourceSet.getOutput().dir(Maps.of((Object)"builtBy", (Object)compileTask.getName()), (Object)destinationDir);
                        }
                        catch (UnknownDomainObjectException unknownDomainObjectException) {
                            // empty catch block
                        }
                    });
                });
            });
            ConfigurableFileCollection allSrcDirs = objects.fileCollection().from(new Object[]{bndProject.getAllsourcepath()});
            extension.getExtensions().getExtraProperties().set("allSrcDirs", (Object)allSrcDirs);
            DependencyHandler dependencies = project.getDependencies();
            dependencies.add("implementation", (Object)this.pathFiles(bndProject.getBuildpath()));
            dependencies.add("runtimeOnly", (Object)objects.fileCollection().from(new Object[]{bndProject.getSrcOutput()}));
            dependencies.add("testImplementation", (Object)this.pathFiles(bndProject.getTestpath()));
            dependencies.add("testRuntimeOnly", (Object)objects.fileCollection().from(new Object[]{bndProject.getTestOutput()}));
            ConfigurableFileCollection javacBootclasspath = objects.fileCollection().from(new Object[]{this.decontainer(bndProject.getBootclasspath())});
            String javac = bndProject.getProperty("javac", "javac");
            Optional<String> javacSource = this.optional(bndProject.getProperty("javac.source"));
            Optional<String> javacTarget = this.optional(bndProject.getProperty("javac.target"));
            Optional<String> javacProfile = this.optional(bndProject.getProperty("javac.profile"));
            boolean javacDebug = bndProject.is("javac.debug");
            boolean javacDeprecation = Processor.isTrue((String)bndProject.getProperty("javac.deprecation", "true"));
            String javacEncoding = bndProject.getProperty("javac.encoding", "UTF-8");
            if (BndUtils.isGradleCompatible("7.1")) {
                javaPlugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
                javacSource.ifPresent(arg_0 -> ((JavaPluginExtension)javaPlugin).setSourceCompatibility(arg_0));
                javacTarget.ifPresent(arg_0 -> ((JavaPluginExtension)javaPlugin).setTargetCompatibility(arg_0));
            } else {
                javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javacSource.ifPresent(arg_0 -> ((JavaPluginConvention)javaPlugin).setSourceCompatibility(arg_0));
                javacTarget.ifPresent(arg_0 -> ((JavaPluginConvention)javaPlugin).setTargetCompatibility(arg_0));
            }
            tasks.withType(JavaCompile.class).configureEach(t -> {
                CompileOptions options = t.getOptions();
                javacSource.ifPresent(arg_0 -> ((JavaCompile)t).setSourceCompatibility(arg_0));
                javacTarget.ifPresent(arg_0 -> ((JavaCompile)t).setTargetCompatibility(arg_0));
                if (javacSource.isPresent() && javacTarget.isPresent()) {
                    Property supportsRelease = objects.property(Boolean.class).value(t.getJavaCompiler().map(javaCompiler -> javaCompiler.getMetadata().getLanguageVersion().canCompileOrRun(9)));
                    options.getRelease().convention(project.provider(() -> {
                        JavaVersion targetVersion;
                        JavaVersion sourceVersion;
                        if (((Boolean)supportsRelease.getOrElse((Object)JavaVersion.current().isJava9Compatible())).booleanValue() && Objects.equals(sourceVersion = JavaVersion.toVersion(javacSource.get()), targetVersion = JavaVersion.toVersion(javacTarget.get())) && javacBootclasspath.isEmpty() && !javacProfile.isPresent()) {
                            return Integer.valueOf(sourceVersion.getMajorVersion());
                        }
                        return null;
                    }));
                }
                if (javacDebug) {
                    options.getDebugOptions().setDebugLevel("source,lines,vars");
                }
                options.setVerbose(t.getLogger().isDebugEnabled());
                options.setListFiles(t.getLogger().isInfoEnabled());
                options.setDeprecation(javacDeprecation);
                options.setEncoding(javacEncoding);
                if (!Objects.equals(javac, "javac")) {
                    options.setFork(true);
                    options.getForkOptions().setExecutable(javac);
                }
                if (!javacBootclasspath.isEmpty()) {
                    options.setFork(true);
                    options.setBootstrapClasspath((FileCollection)javacBootclasspath);
                }
                options.getCompilerArgumentProviders().add(this.argProvider(javacProfile.map(profile -> Arrays.asList("-profile", profile))));
                t.doFirst("checkErrors", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        org.gradle.api.logging.Logger logger = tt.getLogger();
                        BndPlugin.this.checkErrors(logger);
                        if (logger.isInfoEnabled()) {
                            logger.info("Compile to {}", (Object)BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)t.getDestinationDirectory()));
                            if (t.getOptions().getRelease().isPresent()) {
                                logger.info("--release {} {}", BndUtils.unwrap(t.getOptions().getRelease()), (Object)Strings.join((String)" ", (Iterable)t.getOptions().getAllCompilerArgs()));
                            } else {
                                logger.info("-source {} -target {} {}", new Object[]{t.getSourceCompatibility(), t.getTargetCompatibility(), Strings.join((String)" ", (Iterable)t.getOptions().getAllCompilerArgs())});
                            }
                            logger.info("-classpath {}", (Object)t.getClasspath().getAsPath());
                            if (Objects.nonNull(t.getOptions().getBootstrapClasspath())) {
                                logger.info("-bootclasspath {}", (Object)t.getOptions().getBootstrapClasspath().getAsPath());
                            }
                        }
                    }
                });
            });
            TaskProvider jar = tasks.named("jar", AbstractArchiveTask.class, t -> {
                t.setDescription("Jar this project's bundles.");
                t.getActions().clear();
                t.setEnabled(!bndProject.isNoBundles());
                t.getArchiveFileName().set(project.provider(() -> StreamSupport.stream(deliverables.spliterator(), false).filter(Objects::nonNull).map(File::getName).findFirst().orElse(bndProject.getName())));
                List projectDirInputsExcludes = Strings.splitAsStream((String)bndProject.mergeProperties("-builderignore")).map(i -> i.concat("/")).collect(Collectors.toList());
                t.getInputs().files(new Object[]{objects.fileTree().from((Object)layout.getProjectDirectory()).matching(filterable -> {
                    sourceSets.forEach(sourceSet -> {
                        filterable.exclude((Iterable)sourceSet.getAllSource().getSourceDirectories().getFiles().stream().map(arg_0 -> ((Project)project).relativePath(arg_0)).collect(Collectors.toList()));
                        filterable.exclude((Iterable)sourceSet.getOutput().getFiles().stream().map(arg_0 -> ((Project)project).relativePath(arg_0)).collect(Collectors.toList()));
                    });
                    filterable.exclude(new String[]{project.relativePath((Object)layout.getBuildDirectory())});
                    filterable.exclude((Iterable)projectDirInputsExcludes);
                })}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("projectFolder");
                t.getInputs().files(new Object[]{((SourceSet)sourceSets.getByName("main")).getCompileClasspath()}).withNormalizer(ClasspathNormalizer.class).withPropertyName("buildpath");
                t.getInputs().files(new Object[]{this.getBuildDependencies("jar")}).withPropertyName("buildDependencies");
                TaskInputFilePropertyBuilder bndConfigurationInput = t.getInputs().files(new Object[]{this.bndConfiguration()}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("bndConfiguration");
                if (BndUtils.isGradleCompatible("7.2")) {
                    bndConfigurationInput.normalizeLineEndings();
                }
                t.getOutputs().files(new Object[]{deliverables}).withPropertyName("artifacts");
                t.getOutputs().file((Object)layout.getBuildDirectory().file("buildfiles")).withPropertyName("buildfiles");
                t.doLast("build", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        File[] built;
                        try {
                            built = bndProject.build();
                            if (Objects.nonNull(built)) {
                                long now = System.currentTimeMillis();
                                for (File f : built) {
                                    f.setLastModified(now);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Project %s failed to build", bndProject.getName()), (Throwable)e);
                        }
                        BndPlugin.this.checkErrors(tt.getLogger());
                        if (Objects.nonNull(built)) {
                            tt.getLogger().info("Generated bundles: {}", (Object)built);
                        }
                    }
                });
            });
            TaskProvider jarDependencies = tasks.register("jarDependencies", t -> {
                t.setDescription("Jar all projects this project depends on.");
                t.setGroup("build");
                t.dependsOn(new Object[]{this.getBuildDependencies("jar")});
            });
            TaskProvider buildDependencies = tasks.register("buildDependencies", t -> {
                t.setDescription("Assembles and tests all projects this project depends on.");
                t.setGroup("build");
                t.dependsOn(new Object[]{this.getTestDependencies("buildNeeded")});
            });
            TaskProvider buildNeeded = tasks.named("buildNeeded", t -> t.dependsOn(new Object[]{buildDependencies}));
            TaskProvider buildDependents = tasks.named("buildDependents", t -> t.dependsOn(new Object[]{this.getDependents("buildDependents")}));
            TaskProvider release = tasks.register("release", t -> {
                t.setDescription("Release this project to the release repository.");
                t.setGroup("publishing");
                t.setEnabled(!bndProject.isNoBundles() && !bndProject.getProperty("-releaserepo", "unset").isEmpty());
                t.getInputs().files(new Object[]{jar}).withPropertyName(jar.getName());
                t.doLast("release", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        try {
                            bndProject.release();
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Project %s failed to release", bndProject.getName()), (Throwable)e);
                        }
                        BndPlugin.this.checkErrors(tt.getLogger());
                    }
                });
            });
            TaskProvider releaseDependencies = tasks.register("releaseDependencies", t -> {
                t.setDescription("Release all projects this project depends on.");
                t.setGroup("publishing");
                t.dependsOn(new Object[]{this.getBuildDependencies("releaseNeeded")});
            });
            TaskProvider releaseNeeded = tasks.register("releaseNeeded", t -> {
                t.setDescription("Release this project and all projects it depends on.");
                t.setGroup("publishing");
                t.dependsOn(new Object[]{releaseDependencies, release});
            });
            TaskProvider test = tasks.named("test", AbstractTestTask.class, t -> {
                t.setEnabled(!bndProject.is("-nojunit") && !bndProject.is("no.junit"));
                t.getInputs().files(new Object[]{this.getBuildDependencies("jar")}).withPropertyName("buildDependencies");
                t.doFirst("checkErrors", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        BndPlugin.this.checkErrors(tt.getLogger(), t.getIgnoreFailures());
                    }
                });
            });
            TaskProvider testOSGi = tasks.register("testOSGi", TestOSGi.class, t -> {
                t.setDescription("Runs the OSGi JUnit tests by launching a framework and running the tests in the launched framework.");
                t.setEnabled(!bndProject.is("-nojunitosgi") && !bndProject.getUnprocessedProperty("Test-Cases", "").isEmpty());
                t.getInputs().files(new Object[]{jar}).withPropertyName(jar.getName());
                t.getBndrun().fileValue(bndProject.getPropertiesFile());
            });
            TaskProvider check = tasks.named("check", t -> t.dependsOn(new Object[]{testOSGi}));
            TaskProvider checkDependencies = tasks.register("checkDependencies", t -> {
                t.setDescription("Runs all checks on all projects this project depends on.");
                t.setGroup("verification");
                t.dependsOn(new Object[]{this.getTestDependencies("checkNeeded")});
            });
            TaskProvider checkNeeded = tasks.register("checkNeeded", t -> {
                t.setDescription("Runs all checks on this project and all projects it depends on.");
                t.setGroup("verification");
                t.dependsOn(new Object[]{checkDependencies, check});
            });
            TaskProvider clean = tasks.named("clean", Delete.class, t -> {
                t.setDescription("Cleans the build and compiler output directories of this project.");
                t.delete(new Object[]{layout.getBuildDirectory(), ((SourceSet)sourceSets.getByName("main")).getOutput(), ((SourceSet)sourceSets.getByName("test")).getOutput()});
                generate.ifPresent(xva$0 -> t.delete(new Object[]{xva$0}));
            });
            TaskProvider cleanDependencies = tasks.register("cleanDependencies", t -> {
                t.setDescription("Cleans all projects this project depends on.");
                t.setGroup("build");
                t.dependsOn(new Object[]{this.getTestDependencies("cleanNeeded")});
            });
            TaskProvider cleanNeeded = tasks.register("cleanNeeded", t -> {
                t.setDescription("Cleans this project and all projects it depends on.");
                t.setGroup("build");
                t.dependsOn(new Object[]{cleanDependencies, clean});
            });
            TaskProvider assemble = tasks.named("assemble");
            Map<String, File> bndruns = layout.getProjectDirectory().getAsFileTree().matching(filterable -> filterable.include(new String[]{"*.bndrun"})).getFiles().stream().collect(Collectors.toMap(runFile -> {
                String name = runFile.getName();
                return Optional.ofNullable(Strings.extension((String)name)).map(parts -> parts[0]).orElse(name);
            }, runFile -> runFile));
            List exportTasks = MapStream.of(bndruns).mapToObj((name, runFile) -> tasks.register("export.".concat((String)name), Export.class, t -> {
                t.setDescription(String.format("Export the %s file.", runFile.getName()));
                t.dependsOn(new Object[]{assemble});
                t.getBndrun().fileValue(runFile);
                t.getExporter().set((Object)"bnd.executablejar");
            })).collect(Collectors.toList());
            TaskProvider export = tasks.register("export", t -> {
                t.setDescription("Export all the bndrun files.");
                t.setGroup("publishing");
                t.dependsOn(new Object[]{exportTasks});
            });
            List runbundlesTasks = MapStream.of(bndruns).mapToObj((name, runFile) -> tasks.register("runbundles.".concat((String)name), Export.class, t -> {
                t.setDescription(String.format("Create a distribution of the runbundles in the %s file.", runFile.getName()));
                t.dependsOn(new Object[]{assemble});
                t.getBndrun().fileValue(runFile);
                t.getExporter().set((Object)"bnd.runbundles");
            })).collect(Collectors.toList());
            TaskProvider runbundles = tasks.register("runbundles", t -> {
                t.setDescription("Create a distribution of the runbundles in each of the bndrun files.");
                t.setGroup("publishing");
                t.dependsOn(new Object[]{runbundlesTasks});
            });
            List resolveTasks = MapStream.of(bndruns).mapToObj((name, runFile) -> tasks.register("resolve.".concat((String)name), Resolve.class, t -> {
                t.setDescription(String.format("Resolve the runbundles required for %s file.", runFile.getName()));
                t.dependsOn(new Object[]{assemble});
                t.getBndrun().fileValue(runFile);
            })).collect(Collectors.toList());
            TaskProvider resolve = tasks.register("resolve", t -> {
                t.setDescription("Resolve the runbundles required for each of the bndrun files.");
                t.setGroup("verification");
                t.dependsOn(new Object[]{resolveTasks});
            });
            bndruns.forEach((name, runFile) -> tasks.register("run.".concat((String)name), Bndrun.class, t -> {
                t.setDescription(String.format("Run the bndrun file %s.", runFile.getName()));
                t.dependsOn(new Object[]{assemble});
                t.getBndrun().fileValue(runFile);
            }));
            bndruns.forEach((name, runFile) -> tasks.register("testrun.".concat((String)name), TestOSGi.class, t -> {
                t.setDescription(String.format("Runs the OSGi JUnit tests in the bndrun file %s.", runFile.getName()));
                t.dependsOn(new Object[]{assemble});
                t.getBndrun().fileValue(runFile);
            }));
            Collection dependson = bndProject.getDependson();
            TaskProvider echo = tasks.register("echo", arg_0 -> this.lambda$apply$65(tasks, project, workspace, layout, dependson, sourceSets, (FileCollection)allSrcDirs, deliverables, javacProfile, arg_0));
            TaskProvider bndproperties = tasks.register("bndproperties", t -> {
                t.setDescription("Displays the bnd properties.");
                t.setGroup("help");
                t.doLast("bndproperties", (Action)new Action<Task>(){

                    public void execute(Task tt) {
                        try (Formatter f = new Formatter();){
                            f.format("------------------------------------------------------------%n", new Object[0]);
                            f.format("Project %s // Bnd version %s%n", project.getName(), About.getBndVersion());
                            f.format("------------------------------------------------------------%n", new Object[0]);
                            f.format("%n", new Object[0]);
                            bndProject.getPropertyKeys(true).stream().sorted().forEachOrdered(key -> f.format("%s: %s%n", key, bndProject.getProperty(key, "")));
                            f.format("%n", new Object[0]);
                            System.out.print(f.toString());
                        }
                        BndPlugin.this.checkErrors(tt.getLogger(), true);
                    }
                });
            });
            Project noparallel = workspace.hasProperty("cnf") ? (Project)workspace.property("cnf") : workspace;
            bndProject.getMergedParameters("-noparallel").forEach((key, attrs) -> {
                String category = Processor.removeDuplicateMarker((String)key);
                Provider resource = noparallel.getLayout().getBuildDirectory().dir("noparallel/".concat(category));
                String taskNames = Objects.nonNull(attrs) ? attrs.get("task") : null;
                Strings.splitAsStream((String)taskNames).forEach(taskName -> tasks.named(taskName, t -> t.getOutputs().dir((Object)resource).withPropertyName(category)));
            });
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    private Provider<List<TaskProvider<Task>>> getTasks(Collection<? extends aQute.bnd.build.Project> projects, String taskName) {
        return this.project.provider(() -> projects.stream().map(p -> this.workspace.project(p.getName()).getTasks().named(taskName)).collect(Collectors.toList()));
    }

    private ConfigurableFileCollection pathFiles(Collection<? extends Container> path) {
        return this.objects.fileCollection().from(new Object[]{this.decontainer(path)}).builtBy(new Object[]{this.getTasks(path.stream().filter(c -> c.getType() == Container.TYPE.PROJECT).map(Container::getProject).collect(Collectors.toList()), "jar")});
    }

    private Provider<List<TaskProvider<Task>>> getBuildDependencies(String taskName) {
        try {
            return this.getTasks(this.bndProject.getBuildDependencies(), taskName);
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    private Provider<List<TaskProvider<Task>>> getTestDependencies(String taskName) {
        try {
            return this.getTasks(this.bndProject.getTestDependencies(), taskName);
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    private Provider<List<TaskProvider<Task>>> getDependents(String taskName) {
        try {
            return this.getTasks(this.bndProject.getDependents(), taskName);
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    private List<File> decontainer(Collection<? extends Container> path) {
        return path.stream().map(Container::getFile).collect(Collectors.toList());
    }

    private <ITERABLE extends Iterable<String>> CommandLineArgumentProvider argProvider(final Optional<ITERABLE> provider) {
        return new CommandLineArgumentProvider(){

            public Iterable<String> asArguments() {
                return provider.orElseGet(() -> Collections.emptyList());
            }
        };
    }

    private ConfigurableFileCollection bndConfiguration() {
        Workspace bndWorkspace = this.bndProject.getWorkspace();
        return this.objects.fileCollection().from(new Object[]{bndWorkspace.getPropertiesFile(), bndWorkspace.getIncluded(), this.bndProject.getPropertiesFile(), this.bndProject.getIncluded()});
    }

    private void checkErrors(org.gradle.api.logging.Logger logger) {
        this.checkProjectErrors(this.bndProject, logger, false);
    }

    private void checkErrors(org.gradle.api.logging.Logger logger, boolean ignoreFailures) {
        this.checkProjectErrors(this.bndProject, logger, ignoreFailures);
    }

    private void checkProjectErrors(aQute.bnd.build.Project p, org.gradle.api.logging.Logger logger, boolean ignoreFailures) {
        p.getInfo((Reporter)p.getWorkspace(), p.getWorkspace().getBase().getName().concat(" :"));
        boolean failed = !ignoreFailures && !p.isOk();
        int errorCount = p.getErrors().size();
        BndUtils.logReport((Report)p, logger);
        p.clear();
        if (failed) {
            String str = errorCount == 1 ? "%s has errors, one error was reported" : (errorCount > 1 ? "%s has errors, %s errors were reported" : "%s has errors even though no errors were reported");
            throw new GradleException(String.format(str, p.getName(), errorCount));
        }
    }

    private Optional<String> optional(String value) {
        return Strings.nonNullOrEmpty((String)value) ? Optional.of(value) : Optional.empty();
    }

    private static Object getter(Object target, String name) {
        try {
            String getterSuffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Class<?> targetClass = target.getClass();
            while (!Modifier.isPublic(targetClass.getModifiers())) {
                targetClass = targetClass.getSuperclass();
            }
            MethodHandle mh = MethodHandles.publicLookup().unreflect(targetClass.getMethod("get" + getterSuffix, new Class[0]));
            return mh.invoke(target);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Could not find getter method for field {}", (Object)name, (Object)e);
            return null;
        }
    }

    private /* synthetic */ void lambda$apply$65(TaskContainer tasks, final Project project, final Project workspace, final ProjectLayout layout, final Collection dependson, final SourceSetContainer sourceSets, final FileCollection allSrcDirs, final FileCollection deliverables, final Optional javacProfile, Task t) {
        t.setDescription("Displays the bnd project information.");
        t.setGroup("help");
        final JavaCompile compileJava = (JavaCompile)BndUtils.unwrap(tasks.named("compileJava", JavaCompile.class));
        final JavaCompile compileTestJava = (JavaCompile)BndUtils.unwrap(tasks.named("compileTestJava", JavaCompile.class));
        t.doLast("echo", (Action)new Action<Task>(){

            public void execute(Task tt) {
                try (Formatter f = new Formatter();){
                    f.format("------------------------------------------------------------%n", new Object[0]);
                    f.format("Project %s // Bnd version %s%n", project.getName(), About.getBndVersion());
                    f.format("------------------------------------------------------------%n", new Object[0]);
                    f.format("%n", new Object[0]);
                    f.format("project.workspace:      %s%n", workspace.getLayout().getProjectDirectory());
                    f.format("project.name:           %s%n", project.getName());
                    f.format("project.dir:            %s%n", layout.getProjectDirectory());
                    f.format("target:                 %s%n", BndUtils.unwrap(layout.getBuildDirectory()));
                    f.format("project.dependson:      %s%n", dependson);
                    f.format("project.sourcepath:     %s%n", ((SourceSet)sourceSets.getByName("main")).getAllSource().getSourceDirectories().getAsPath());
                    f.format("project.output:         %s%n", BndUtils.unwrap(compileJava.getDestinationDirectory()));
                    f.format("project.buildpath:      %s%n", compileJava.getClasspath().getAsPath());
                    f.format("project.allsourcepath:  %s%n", allSrcDirs.getAsPath());
                    f.format("project.testsrc:        %s%n", ((SourceSet)sourceSets.getByName("test")).getAllSource().getSourceDirectories().getAsPath());
                    f.format("project.testoutput:     %s%n", BndUtils.unwrap(compileTestJava.getDestinationDirectory()));
                    f.format("project.testpath:       %s%n", compileTestJava.getClasspath().getAsPath());
                    if (Objects.nonNull(compileJava.getOptions().getBootstrapClasspath())) {
                        f.format("project.bootclasspath:  %s%n", compileJava.getOptions().getBootstrapClasspath().getAsPath());
                    }
                    f.format("project.deliverables:   %s%n", deliverables.getFiles());
                    String executable = Optional.ofNullable(compileJava.getOptions().getForkOptions().getExecutable()).orElseGet(() -> (String)compileJava.getJavaCompiler().map(javaCompiler -> IO.absolutePath((File)BndUtils.unwrapFile((FileSystemLocation)javaCompiler.getExecutablePath()))).getOrElse((Object)"javac"));
                    f.format("javac:                  %s%n", executable);
                    if (compileJava.getOptions().getRelease().isPresent()) {
                        f.format("--release:              %s%n", BndUtils.unwrap(compileJava.getOptions().getRelease()));
                    } else {
                        f.format("-source:                %s%n", compileJava.getSourceCompatibility());
                        f.format("-target:                %s%n", compileJava.getTargetCompatibility());
                    }
                    if (javacProfile.isPresent()) {
                        f.format("-profile:               %s%n", javacProfile.get());
                    }
                    System.out.print(f.toString());
                }
                BndPlugin.this.checkErrors(tt.getLogger(), true);
            }
        });
    }
}

