/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.gradle.BeanProperties;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Processor;
import aQute.bnd.stream.MapStream;
import aQute.bnd.unmodifiable.Maps;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.work.NormalizeLineEndings;

public class BundleTaskExtension {
    public static final String NAME = "bundle";
    private final RegularFileProperty bndfile;
    private final ConfigurableFileCollection classpath;
    private final Provider<String> bnd;
    private final MapProperty<String, Object> properties;
    private final ConfigurableFileCollection allSource;
    private final Jar task;
    private final ProjectLayout layout;
    private final File buildFile;
    private final ListProperty<CharSequence> instructions;

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NormalizeLineEndings
    @Optional
    public RegularFileProperty getBndfile() {
        return this.bndfile;
    }

    @InputFiles
    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Input
    @Optional
    public Provider<String> getBnd() {
        return this.bnd;
    }

    @Input
    public MapProperty<String, Object> getProperties() {
        return this.properties;
    }

    public BundleTaskExtension(Jar task) {
        this.task = task;
        Project project = task.getProject();
        this.layout = project.getLayout();
        ObjectFactory objects = project.getObjects();
        this.buildFile = project.getBuildFile();
        this.bndfile = objects.fileProperty();
        this.instructions = objects.listProperty(CharSequence.class).empty();
        this.bnd = this.instructions.map(list -> Strings.join((String)"\n", (Iterable)list));
        this.classpath = objects.fileCollection();
        this.allSource = objects.fileCollection();
        SourceSet mainSourceSet = (SourceSet)BndUtils.sourceSets(project).getByName("main");
        this.setSourceSet(mainSourceSet);
        this.classpath(mainSourceSet.getCompileClasspath());
        this.properties = objects.mapProperty(String.class, Object.class).convention(Maps.of((Object)"project", (Object)"__convention__"));
        task.getInputs().files(new Object[]{this.getClasspath()}).withNormalizer(ClasspathNormalizer.class).withPropertyName("classpath");
        TaskInputFilePropertyBuilder bndfileInput = task.getInputs().file((Object)this.getBndfile()).optional().withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("bndfile");
        if (BndUtils.isGradleCompatible("7.2")) {
            bndfileInput.normalizeLineEndings();
        }
        task.getInputs().property("bnd", this.getBnd());
        task.getInputs().property("properties", this.getProperties());
    }

    public void setBnd(CharSequence line) {
        this.instructions.empty();
        this.bnd(line);
    }

    public void bnd(CharSequence ... lines) {
        this.instructions.addAll((Object[])lines);
    }

    public void setBnd(Provider<? extends CharSequence> lines) {
        this.instructions.empty();
        this.bnd(lines);
    }

    public void bnd(Provider<? extends CharSequence> lines) {
        this.instructions.add(lines);
    }

    public void setBnd(Map<String, ?> map) {
        this.instructions.empty();
        this.bnd(map);
    }

    public void bnd(Map<String, ?> map) {
        map.forEach((key, value) -> this.instructions.add((Object)(key + "=" + value)));
    }

    public ConfigurableFileCollection classpath(Object ... paths) {
        return BndUtils.builtBy(this.getClasspath().from(paths), paths);
    }

    public void setClasspath(Object path) {
        this.getClasspath().setFrom(Collections.emptyList());
        this.getClasspath().setBuiltBy(Collections.emptyList());
        this.classpath(path);
    }

    public void setSourceSet(SourceSet sourceSet) {
        this.getAllSource().setFrom((Iterable)sourceSet.getAllSource().getSourceDirectories());
        BndUtils.jarLibraryElements((Task)this.getTask(), sourceSet.getCompileClasspathConfigurationName());
    }

    ConfigurableFileCollection getAllSource() {
        return this.allSource;
    }

    File getBuildFile() {
        return this.buildFile;
    }

    ProjectLayout getLayout() {
        return this.layout;
    }

    Jar getTask() {
        return this.task;
    }

    public Action<Task> buildAction() {
        return new BuildAction();
    }

    private class BuildAction
    implements Action<Task> {
        private BuildAction() {
        }

        public void execute(Task t) {
            try {
                File projectDir = BndUtils.unwrapFile((FileSystemLocation)BundleTaskExtension.this.getLayout().getProjectDirectory());
                File buildDir = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getLayout().getBuildDirectory());
                File buildFile = BundleTaskExtension.this.getBuildFile();
                FileCollection sourcepath = BundleTaskExtension.this.getAllSource().filter(file -> file.exists());
                BeanProperties gradleProperties = new BeanProperties();
                gradleProperties.putAll((Map<?, ?>)((Map)BndUtils.unwrap(BundleTaskExtension.this.getProperties())));
                gradleProperties.computeIfPresent("project", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "__convention__".equals(v) ? BundleTaskExtension.this.getTask().getProject() : v));
                gradleProperties.putIfAbsent("task", BundleTaskExtension.this.getTask());
                try (Builder builder = new Builder(new Processor((Properties)gradleProperties, false));){
                    String bundleVersion;
                    File temporaryBndFile = File.createTempFile("bnd", ".bnd", BundleTaskExtension.this.getTask().getTemporaryDir());
                    try (PrintWriter writer = IO.writer((File)temporaryBndFile);){
                        ((UTF8Properties)MapStream.of((Map)BundleTaskExtension.this.getTask().getManifest().getEffectiveManifest().getAttributes()).filterKey(key -> !Objects.equals(key, "Manifest-Version")).mapValue(Object::toString).collect(MapStream.toMap((k1, k2) -> {
                            throw new IllegalStateException("Duplicate key " + k1);
                        }, UTF8Properties::new))).replaceHere(projectDir).store((Writer)writer, null);
                        java.util.Optional<File> bndfile = BndUtils.unwrapFileOptional((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getBndfile()).filter(File::isFile);
                        if (bndfile.isPresent()) {
                            builder.loadProperties(bndfile.get()).store(writer, null);
                        } else {
                            String bnd = BndUtils.unwrap(BundleTaskExtension.this.getBnd());
                            if (!bnd.isEmpty()) {
                                UTF8Properties props = new UTF8Properties();
                                props.load(bnd, buildFile, (Reporter)builder);
                                props.replaceHere(projectDir).store((Writer)writer, null);
                            }
                        }
                    }
                    builder.setProperties(temporaryBndFile, projectDir);
                    builder.setProperty("project.output", buildDir.getCanonicalPath());
                    if (builder.is("-nobundles")) {
                        return;
                    }
                    if (!Objects.equals(builder.getSubBuilders(), Collections.singletonList(builder))) {
                        throw new GradleException("Sub-bundles are not supported by this task");
                    }
                    File archiveFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getTask().getArchiveFile());
                    String archiveFileName = (String)BndUtils.unwrap(BundleTaskExtension.this.getTask().getArchiveFileName());
                    String archiveBaseName = (String)BndUtils.unwrap(BundleTaskExtension.this.getTask().getArchiveBaseName());
                    String archiveClassifier = (String)BndUtils.unwrap(BundleTaskExtension.this.getTask().getArchiveClassifier());
                    String archiveVersion = BndUtils.unwrapOptional(BundleTaskExtension.this.getTask().getArchiveVersion()).orElse(null);
                    File archiveCopyFile = new File(BundleTaskExtension.this.getTask().getTemporaryDir(), archiveFileName);
                    IO.copy((File)archiveFile, (File)archiveCopyFile);
                    aQute.bnd.osgi.Jar bundleJar = new aQute.bnd.osgi.Jar(archiveFileName, archiveCopyFile);
                    String reproducible = builder.getProperty("-reproducible");
                    bundleJar.setReproducible(Objects.nonNull(reproducible) ? Processor.isTrue((String)reproducible) : !BundleTaskExtension.this.getTask().isPreserveFileTimestamps());
                    bundleJar.updateModified(archiveFile.lastModified(), "time of Jar task generated jar");
                    bundleJar.setManifest(new Manifest());
                    builder.setJar(bundleJar);
                    FileCollection buildpath = BundleTaskExtension.this.getClasspath().filter(file -> {
                        if (!file.exists()) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        try (ZipFile zip = new ZipFile((File)file);){
                            zip.entries();
                        }
                        catch (IOException e) {
                            return false;
                        }
                        return true;
                    });
                    builder.setProperty("project.buildpath", buildpath.getAsPath());
                    builder.setClasspath(buildpath.getFiles().toArray(new File[0]));
                    BundleTaskExtension.this.getTask().getLogger().debug("builder classpath: {}", builder.getClasspath().stream().map(aQute.bnd.osgi.Jar::getSource).collect(Collectors.toList()));
                    builder.setProperty("project.sourcepath", sourcepath.getAsPath());
                    builder.setSourcepath(sourcepath.getFiles().toArray(new File[0]));
                    BundleTaskExtension.this.getTask().getLogger().debug("builder sourcepath: {}", (Object)builder.getSourcePath());
                    String bundleSymbolicName = builder.getProperty("Bundle-SymbolicName");
                    if (this.isEmpty(bundleSymbolicName)) {
                        bundleSymbolicName = archiveClassifier.isEmpty() ? archiveBaseName : archiveBaseName + "-" + archiveClassifier;
                        builder.setProperty("Bundle-SymbolicName", bundleSymbolicName);
                    }
                    if (this.isEmpty(bundleVersion = builder.getProperty("Bundle-Version"))) {
                        builder.setProperty("Bundle-Version", MavenVersion.parseMavenString((String)archiveVersion).getOSGiVersion().toString());
                    }
                    BundleTaskExtension.this.getTask().getLogger().debug("builder properties: {}", (Object)builder.getProperties());
                    aQute.bnd.osgi.Jar builtJar = builder.build();
                    if (!builder.isOk()) {
                        BndUtils.logReport((Report)builder, BundleTaskExtension.this.getTask().getLogger());
                        this.failTask("Bundle " + archiveFileName + " has errors", archiveFile);
                    }
                    builtJar.write(archiveFile);
                    long now = System.currentTimeMillis();
                    archiveFile.setLastModified(now);
                    BndUtils.logReport((Report)builder, BundleTaskExtension.this.getTask().getLogger());
                    if (!builder.isOk()) {
                        this.failTask("Bundle " + archiveFileName + " has errors", archiveFile);
                    }
                }
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }

        private void failTask(String msg, File archiveFile) {
            IO.delete((File)archiveFile);
            throw new GradleException(msg);
        }

        private boolean isEmpty(String header) {
            return Objects.isNull(header) || header.trim().isEmpty() || "<<EMPTY>>".equals(header);
        }
    }
}

