/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;

public class Baseline
extends DefaultTask {
    private boolean ignoreFailures = false;
    private final ListProperty<String> diffpackages;
    private final ListProperty<String> diffignore;
    private final Property<String> baselineReportDirName;
    private final DirectoryProperty baselineReportDirectory;
    private final RegularFileProperty reportFile;
    private final ConfigurableFileCollection bundleCollection;
    private final ConfigurableFileCollection baselineCollection;
    private final ProjectLayout layout;
    private final ProviderFactory providers;

    @Input
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean getIgnoreFailures() {
        return this.isIgnoreFailures();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public ListProperty<String> getDiffpackages() {
        return this.diffpackages;
    }

    @Input
    public ListProperty<String> getDiffignore() {
        return this.diffignore;
    }

    @Internal(value="Represented by reportFile")
    public Property<String> getBaselineReportDirName() {
        return this.baselineReportDirName;
    }

    @Internal(value="Represented by reportFile")
    public DirectoryProperty getBaselineReportDirectory() {
        return this.baselineReportDirectory;
    }

    @OutputFile
    public RegularFileProperty getReportFile() {
        return this.reportFile;
    }

    public Baseline() {
        Project project = this.getProject();
        this.layout = project.getLayout();
        this.providers = project.getProviders();
        ObjectFactory objects = project.getObjects();
        this.baselineReportDirName = objects.property(String.class).convention((Object)"baseline");
        this.baselineReportDirectory = objects.directoryProperty().convention(((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir(this.baselineReportDirName));
        String taskName = this.getName();
        this.reportFile = objects.fileProperty().convention(this.baselineReportDirectory.file(this.providers.provider(() -> {
            File bundlefile = BndUtils.unwrapFile(this.getBundle());
            String[] parts = Strings.extension((String)bundlefile.getName());
            return String.format("%s/%s.txt", taskName, parts != null ? parts[0] : bundlefile.getName());
        })));
        this.diffignore = objects.listProperty(String.class).empty();
        this.diffpackages = objects.listProperty(String.class).empty();
        this.bundleCollection = objects.fileCollection();
        this.baselineCollection = objects.fileCollection();
        this.getInputs().files(new Object[]{this.bundleCollection}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("bundleCollection");
        this.getInputs().files(new Object[]{this.baselineCollection}).withPropertyName("baselineCollection");
    }

    @InputFile
    public Provider<RegularFile> getBundle() {
        return this.layout.file(this.providers.provider(() -> ((ConfigurableFileCollection)this.bundleCollection).getSingleFile()));
    }

    public void setBundle(Object file) {
        this.bundleCollection.setFrom(new Object[]{file});
        BndUtils.builtBy(this.bundleCollection, file);
    }

    @InputFile
    public Provider<RegularFile> getBaseline() {
        return this.layout.file(this.providers.provider(() -> ((ConfigurableFileCollection)this.baselineCollection).getSingleFile()));
    }

    public void setBaseline(Object file) {
        this.baselineCollection.setFrom(new Object[]{file});
        BndUtils.builtBy(this.baselineCollection, file);
    }

    public void diffignore(String ... diffignore) {
        this.getDiffignore().addAll((Object[])diffignore);
    }

    public void diffpackages(String ... diffpackages) {
        this.getDiffpackages().addAll((Object[])diffpackages);
    }

    @Internal(value="Used by baseline configuration")
    public Jar getBundleTask() {
        ArrayDeque<Object> queue = new ArrayDeque<Object>(this.bundleCollection.getBuiltBy());
        while (!queue.isEmpty()) {
            Object o = queue.removeFirst();
            if (o instanceof Jar) {
                Jar t = (Jar)o;
                if (!Objects.nonNull(t.getExtensions().findByName("bundle"))) continue;
                return t;
            }
            if (o instanceof Provider) {
                Provider p = (Provider)o;
                queue.addFirst(p.get());
                continue;
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                queue.addFirst(m.values());
                continue;
            }
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                queue.addFirst(c.toArray());
                continue;
            }
            if (o instanceof Iterable && !(o instanceof Path)) {
                Iterable i = (Iterable)o;
                queue.addFirst(StreamSupport.stream(i.spliterator(), false).toArray());
                continue;
            }
            if (!(o instanceof Object[])) continue;
            Object[] a = (Object[])o;
            for (int i = a.length - 1; i >= 0; --i) {
                queue.addFirst(a[i]);
            }
        }
        return null;
    }

    @TaskAction
    public void baselineAction() throws Exception {
        File bundle = BndUtils.unwrapFile(this.getBundle());
        File baseline = BndUtils.unwrapFile(this.getBaseline());
        File report = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getReportFile());
        List diffignoreList = (List)((Object)BndUtils.unwrap(this.getDiffignore()));
        List diffpackagesList = (List)((Object)BndUtils.unwrap(this.getDiffpackages()));
        IO.mkdirs((File)report.getParentFile());
        boolean failure = false;
        try (Processor processor = new Processor();
             aQute.bnd.osgi.Jar newer = new aQute.bnd.osgi.Jar(bundle);
             aQute.bnd.osgi.Jar older = new aQute.bnd.osgi.Jar(baseline);){
            this.getLogger().debug("Baseline bundle {} against baseline {}", (Object)bundle, (Object)baseline);
            DiffPluginImpl differ = new DiffPluginImpl();
            differ.setIgnore(new Parameters(Strings.join((Iterable)diffignoreList), (Reporter)processor));
            aQute.bnd.differ.Baseline baseliner = new aQute.bnd.differ.Baseline((Reporter)processor, (Differ)differ);
            List infos = baseliner.baseline(newer, older, new Instructions(new Parameters(Strings.join((Iterable)diffpackagesList), (Reporter)processor))).stream().sorted(Comparator.comparing(info -> info.packageName)).collect(Collectors.toList());
            Baseline.BundleInfo bundleInfo = baseliner.getBundleInfo();
            try (Formatter f = new Formatter(report, "UTF-8", Locale.US);){
                f.format("===============================================================%n", new Object[0]);
                f.format("%s %s %s-%s", bundleInfo.mismatch ? "*" : " ", bundleInfo.bsn, newer.getVersion(), older.getVersion());
                if (bundleInfo.mismatch) {
                    failure = true;
                    if (Objects.nonNull(bundleInfo.suggestedVersion)) {
                        f.format(" suggests %s", bundleInfo.suggestedVersion);
                    }
                    f.format("%n%#2S", baseliner.getDiff());
                }
                f.format("%n===============================================================%n", new Object[0]);
                String format = "%s %-50s %-10s %-10s %-10s %-10s %-10s %s%n";
                f.format(format, " ", "Name", "Type", "Delta", "New", "Old", "Suggest", "If Prov.");
                for (Baseline.Info info2 : infos) {
                    Diff packageDiff = info2.packageDiff;
                    f.format(format, info2.mismatch ? "*" : " ", packageDiff.getName(), packageDiff.getType(), packageDiff.getDelta(), info2.newerVersion, Objects.nonNull(info2.olderVersion) && info2.olderVersion.equals((Object)Version.LOWEST) ? "-" : info2.olderVersion, Objects.nonNull(info2.suggestedVersion) && info2.suggestedVersion.compareTo(info2.newerVersion) <= 0 ? "ok" : info2.suggestedVersion, Objects.nonNull(info2.suggestedIfProviders) ? info2.suggestedIfProviders : "-");
                    if (!info2.mismatch) continue;
                    failure = true;
                    f.format("%#2S%n", packageDiff);
                }
            }
        }
        if (failure) {
            String msg = String.format("Baseline problems detected. See the report in %s.\n%s", report, IO.collect((File)report));
            if (this.isIgnoreFailures()) {
                this.getLogger().error(msg);
            } else {
                throw new GradleException(msg);
            }
        }
    }
}

