/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.Bndrun;
import aQute.lib.io.IO;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.options.Option;

public class TestOSGi
extends Bndrun {
    private final DirectoryProperty resultsDirectory;
    private List<String> tests;

    @OutputDirectory
    public DirectoryProperty getResultsDirectory() {
        return this.resultsDirectory;
    }

    @Input
    @Optional
    public List<String> getTests() {
        return this.tests;
    }

    @Option(option="tests", description="Configures the test class names to be run.")
    public void setTests(List<String> tests) {
        this.tests = tests;
    }

    public TestOSGi() {
        Provider<Directory> testResultsDir = BndUtils.testResultsDir(this.getProject());
        String taskName = this.getName();
        this.resultsDirectory = this.getProject().getObjects().directoryProperty().convention(testResultsDir.map(d -> d.dir(taskName)));
    }

    @Override
    protected void worker(Project run) throws Exception {
        if (this.getJavaLauncher().isPresent() && Objects.equals(run.getProperty("java", "java"), "java")) {
            run.setProperty("java", IO.absolutePath((File)BndUtils.unwrapFile((FileSystemLocation)BndUtils.unwrap(this.getJavaLauncher()).getExecutablePath())));
        }
        this.getLogger().info("Running tests for {} in {}", (Object)run.getPropertiesFile(), (Object)run.getBase());
        this.getLogger().debug("Run properties: {}", (Object)run.getProperties());
        File resultsDir = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getResultsDirectory());
        try {
            run.test(resultsDir, this.getTests());
        }
        finally {
            BndUtils.logReport((Report)run, this.getLogger());
        }
        if (!this.isIgnoreFailures() && !run.isOk()) {
            throw new GradleException(String.format("%s test failure", run.getPropertiesFile()));
        }
    }
}

